/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.cart.supported.core;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class M93C86 {
    private static final Logger LOG = Logger.getLogger(M93C86.class.getName());
    private static final int M93C86_SIZE = 2048;
    private int[] m93c86_data = new int[2048];
    private int eeprom_cs = 0;
    private int eeprom_clock = 0;
    private int eeprom_data_in = 0;
    private int eeprom_data_out = 0;
    private int input_shiftreg = 0;
    private int input_count = 0;
    private int output_shiftreg = 0;
    private int output_count = 0;
    private int command = 0;
    private int addr = 0;
    private int data0 = 0;
    private int data1 = 0;
    private int write_enable_status = 0;
    private int ready_busy_status = 1;
    private static final int CMD00 = 1;
    private static final int CMDWRITE = 2;
    private static final int CMDREAD = 3;
    private static final int CMDERASE = 4;
    private static final int CMDWEN = 5;
    private static final int CMDWDS = 6;
    private static final int CMDERAL = 7;
    private static final int CMDWRAL = 8;
    private static final int CMDREADDUMMY = 9;
    private static final int CMDREADDATA = 10;
    private static final int CMDISBUSY = 11;
    private static final int CMDISREADY = 12;
    private static final int STATUSREADY = 1;
    private static final int STATUSBUSY = 0;

    public void reset_input_shiftreg() {
        this.input_shiftreg = 0;
        this.input_count = 0;
    }

    public int m93c86_read_data() {
        if (this.eeprom_cs == 1) {
            switch (this.command) {
                case 11: {
                    LOG.finest("busy status is 1");
                    this.command = 12;
                    return 0;
                }
                case 12: {
                    LOG.finest("busy status is 0, end of command");
                    this.ready_busy_status = 1;
                    this.command = 0;
                    return 1;
                }
            }
            return this.eeprom_data_out;
        }
        return 0;
    }

    public void m93c86_write_data(int value) {
        if (this.eeprom_cs == 1) {
            this.eeprom_data_in = value;
        }
    }

    public void m93c86_write_select(int value) {
        if (this.eeprom_cs == 0 && value == 1 && this.eeprom_clock == 0) {
            this.reset_input_shiftreg();
        } else if (this.eeprom_cs == 1 && value == 0) {
            switch (this.command) {
                case 2: 
                case 7: 
                case 8: {
                    this.command = 11;
                }
            }
        }
        this.eeprom_cs = value;
        if (this.eeprom_cs == 0 && (this.command == 3 || this.command == 9 || this.command == 10)) {
            this.command = 0;
        }
    }

    public void m93c86_write_clock(int value) {
        if (this.eeprom_cs == 1 && value == 1 && this.eeprom_clock == 0) {
            if (this.command == 9) {
                this.output_shiftreg = this.m93c86_data[this.addr << 1];
                this.eeprom_data_out = 0;
                this.output_count = 0;
                this.eeprom_data_out = this.output_shiftreg >> 7 & 1;
                LOG.finest(String.format("output %d pos %d addr %04x", this.eeprom_data_out, this.output_count, this.addr));
                this.output_shiftreg <<= 1;
                ++this.output_count;
                this.command = 10;
                LOG.finest(String.format("load output from %04x with %02x", this.addr, this.output_shiftreg));
            } else if (this.command == 10) {
                this.eeprom_data_out = this.output_shiftreg >> 7 & 1;
                this.output_shiftreg <<= 1;
                ++this.output_count;
                switch (this.output_count) {
                    case 8: {
                        this.output_shiftreg = this.m93c86_data[(this.addr << 1) + 1];
                        LOG.finest(String.format("reload output from %04x with %02x", this.addr, this.output_shiftreg));
                        break;
                    }
                    case 16: {
                        this.addr = this.addr + 1 & 0x3FF;
                        this.output_shiftreg = this.m93c86_data[this.addr << 1];
                        this.output_count = 0;
                        LOG.finest(String.format("reload output from %04x with %02x", this.addr, this.output_shiftreg));
                    }
                }
            } else {
                this.input_shiftreg <<= 1;
                this.input_shiftreg |= this.eeprom_data_in;
                ++this.input_count;
                block4 : switch (this.input_count) {
                    case 1: {
                        if (this.eeprom_data_in != 0) break;
                        this.reset_input_shiftreg();
                        break;
                    }
                    case 3: {
                        switch (this.input_shiftreg) {
                            case 4: {
                                this.command = 1;
                                break;
                            }
                            case 5: {
                                this.command = 2;
                                break;
                            }
                            case 6: {
                                this.command = 3;
                                break;
                            }
                            case 7: {
                                this.command = 4;
                            }
                        }
                        LOG.finest(String.format("first three command bits are: %x", this.input_shiftreg));
                        break;
                    }
                    case 5: {
                        if (this.command != 1) break;
                        switch (this.input_shiftreg) {
                            case 16: {
                                this.command = 6;
                                break;
                            }
                            case 17: {
                                this.command = 8;
                                break;
                            }
                            case 18: {
                                this.command = 7;
                                break;
                            }
                            case 19: {
                                this.command = 5;
                                this.write_enable_status = 1;
                            }
                        }
                        LOG.finest(String.format("first five command bits are: %x", this.input_shiftreg));
                        break;
                    }
                    case 13: {
                        switch (this.command) {
                            case 3: {
                                this.command = 9;
                                this.addr = this.input_shiftreg >> 0 & 0x3FF;
                                this.reset_input_shiftreg();
                                LOG.finest(String.format("CMD: read addr %04x", this.addr));
                                break;
                            }
                            case 6: {
                                this.write_enable_status = 0;
                                this.reset_input_shiftreg();
                                this.command = 0;
                                LOG.finest(String.format("CMD: write disable", new Object[0]));
                                break;
                            }
                            case 5: {
                                this.write_enable_status = 1;
                                this.reset_input_shiftreg();
                                this.command = 0;
                                LOG.finest(String.format("CMD: write enable", new Object[0]));
                                break;
                            }
                            case 4: {
                                if (this.write_enable_status == 0) {
                                    LOG.log(Level.SEVERE, "EEPROM: write not permitted for CMD 'erase'");
                                    this.reset_input_shiftreg();
                                    this.command = 0;
                                    break;
                                }
                                this.addr = this.input_shiftreg >> 0 & 0x3FF;
                                this.ready_busy_status = 0;
                                this.reset_input_shiftreg();
                                this.m93c86_data[this.addr << 1] = 255;
                                this.m93c86_data[(this.addr << 1) + 1] = 255;
                                LOG.finest(String.format("CMD: erase addr %04x", this.addr));
                                break;
                            }
                            case 7: {
                                if (this.write_enable_status == 0) {
                                    LOG.log(Level.SEVERE, "EEPROM: write not permitted for CMD 'erase all'");
                                    this.reset_input_shiftreg();
                                    this.command = 0;
                                    break;
                                }
                                this.ready_busy_status = 0;
                                this.reset_input_shiftreg();
                                Arrays.fill(this.m93c86_data, 255);
                                LOG.finest(String.format("CMD: erase all", new Object[0]));
                            }
                        }
                        break;
                    }
                    case 29: {
                        switch (this.command) {
                            case 2: {
                                if (this.write_enable_status == 0) {
                                    LOG.log(Level.SEVERE, "EEPROM: write not permitted for CMD 'write'");
                                    this.reset_input_shiftreg();
                                    this.command = 0;
                                    break block4;
                                }
                                this.addr = this.input_shiftreg >> 16 & 0x3FF;
                                this.data0 = this.input_shiftreg >> 8 & 0xFF;
                                this.data1 = this.input_shiftreg >> 0 & 0xFF;
                                this.ready_busy_status = 0;
                                this.reset_input_shiftreg();
                                this.m93c86_data[this.addr << 1] = this.data0;
                                this.m93c86_data[(this.addr << 1) + 1] = this.data1;
                                LOG.finest(String.format("CMD: write addr %04x %02x %02x", this.addr, this.data0, this.data1));
                                break block4;
                            }
                            case 8: {
                                if (this.write_enable_status == 0) {
                                    LOG.log(Level.SEVERE, "EEPROM: write not permitted for CMD 'write all'");
                                    this.reset_input_shiftreg();
                                    this.command = 0;
                                    break block4;
                                }
                                this.data0 = this.input_shiftreg >> 8 & 0xFF;
                                this.data1 = this.input_shiftreg >> 0 & 0xFF;
                                this.ready_busy_status = 0;
                                this.reset_input_shiftreg();
                                this.addr = 0;
                                while (this.addr < 1024) {
                                    this.m93c86_data[this.addr << 1] = this.data0;
                                    this.m93c86_data[(this.addr << 1) + 1] = this.data1;
                                    ++this.addr;
                                }
                                LOG.finest(String.format("CMD: write all %02x %02x", this.data0, this.data1));
                            }
                        }
                    }
                }
            }
        }
        this.eeprom_clock = value;
    }
}

